
### CRUD operations on REST APIs
1. GET: Get a representation of the target resource’s state at URI.
2. POST: Create a new resource at URI as per the representation enclosed in the request.
3. PUT: Create or replace the state of the target resource at URI with the state defined by the representation enclosed in the request. Complete representation needs to be sent in request body.
4. DELETE: Delete the target resource’s state at URI.
5. PATCH: Update part of the target resource URI. Request body contains only the attributes to be changed. More efficient than PUT.

### HTTP Response codes return relevant status to client
HTTP2xx - Success 
HTTP200 - Successful response / request was OK 
HTTP202 - Accepted. To indicate that request was accepted for processing but is not completed. Useful in Asynchronous flow when sending quick response to avoid latency delays on subsequent operations. If the client sends a GET request to this endpoint, the response should contain the current status of the request. 
HTTP204 - No content found 
HTTP206 - Partial Content success status response code indicates that the request has succeeded and has the body contains the requested ranges of data, as described in the Range header of the request.

HTTP3xx - Redirection and others
  
HTTP4xx - Problem on client side 
HTTP424 - Failed Dependency error 
HTTP404 - endpoint that doesn't exist 
HTTP403 / 401 missing authentication 
HTTP406 - Not acceptable if a media type is not known or null in the request header 
HTTP409 - Conflict (when it’s not possible to update an existing resource through PUT method) HTTP415 - Unsupported media type
  
HTTP5xx - Problem on server side

---
